#include "General.h"
#include "ShadowMute.h"
#include "gmgame.h"
#include "Iterator.h"
#include "cScTextObj.h"
#include "SCAnnouncement.h"
#include "CommandLineParser.h"
#include "engine_tt.h"

bool ShadowMutedPlayers[128];

void* HookupAT3x(void* a, void* b, void* c, void* patch_start, void* patch_end, int (*version_selector)())
{
	return HookupAT3(a,b,c,patch_start,patch_end,version_selector);
}

static int getClientIdByIdentifier(const char* clientIdentifier)
{
	assert(clientIdentifier);
	const cPlayer* player = Find_Player(atoi(clientIdentifier));
	int result;
	if (player)
		result = player->PlayerId;
	else
		result = -1;
	return result;
}

static bool isClientId(const int id)
{
	return id > 0 && id < 128 && Find_Player(id);
}


class CommandSHADOWMUTE :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "ShadowMute"; 
	}
	const char* Get_Help() 
	{ 
		return "SHADOWMUTE <clientId> - Shadow mutes a client."; 
	}
	void Activate(const char* argumentsString)
	{
		CommandLineParser arguments(argumentsString);
		const char* clientIdentifier = arguments.getString();

		if (!clientIdentifier || clientIdentifier[0] == '\0')
			Console_Output("Please enter a client identifier.");
		else
		{
			const int clientId = getClientIdByIdentifier(clientIdentifier);
			if (!isClientId(clientId))
			{
				Console_Output("Please enter a valid client identifier.");
			}
			else
			{
				ShadowMutedPlayers[clientId] = true;
			}
		}
	}
};


class CommandUNSHADOWMUTE :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "UnShadowMute"; 
	}
	const char* Get_Help() 
	{ 
		return "UNSHADOWMUTE <clientId> - Un-Shadow mutes a client."; 
	}
	void Activate(const char* argumentsString)
	{
		CommandLineParser arguments(argumentsString);
		const char* clientIdentifier = arguments.getString();

		if (!clientIdentifier || clientIdentifier[0] == '\0')
			Console_Output("Please enter a client identifier.");
		else
		{
			const int clientId = getClientIdByIdentifier(clientIdentifier);
			if (!isClientId(clientId))
			{
				Console_Output("Please enter a valid client identifier.");
			}
			else
			{
				ShadowMutedPlayers[clientId] = false;
			}
		}
	}
};


class SHADOWMUTE : public Plugin
{
public:
	SHADOWMUTE()
	{
		ConsoleFunctionList.Add(new CommandSHADOWMUTE);
		ConsoleFunctionList.Add(new CommandUNSHADOWMUTE);
		Sort_Function_List();
		Verbose_Help_File();
		RegisterEvent(EVENT_CHAT_HOOK,this);
		RegisterEvent(EVENT_RADIO_HOOK,this);
		RegisterEvent(EVENT_PLAYER_LEAVE_HOOK,this);
	}
	~SHADOWMUTE()
	{
		UnregisterEvent(EVENT_CHAT_HOOK,this);
		UnregisterEvent(EVENT_RADIO_HOOK,this);
		UnregisterEvent(EVENT_PLAYER_LEAVE_HOOK,this);
		const DynamicVectorClass<ConsoleFunctionClass*> consoleFunctions(ConsoleFunctionList);
		TT_FOREACH(consoleFunction, consoleFunctions)
		{
			const char* name = (*consoleFunction)->Get_Name();
			if (name)
			{
				if (_stricmp(name, "ShadowMute") == 0 ||
					_stricmp(name, "UnShadowMute") == 0)
				{
					ConsoleFunctionList.Delete(consoleFunction);
				}
			}
		}
	}


	virtual bool OnChat(int PlayerID,TextMessageEnum Type,const wchar_t *Message,int recieverID)
	{
		if(ShadowMutedPlayers[PlayerID] == false)
		{
			return true;
		}
		else
		{
			cScTextObj *Text = Send_Client_Text(Message,Type,false,PlayerID,recieverID,false,false); //Players will still see their own messages when muted.
			Text->Set_Object_Dirty_Bits(PlayerID,NetworkObjectClass::BIT_CREATION);
			return false;
		}
	}

	virtual bool OnRadioCommand(int PlayerType, int PlayerID, int AnnouncementID, int IconID, AnnouncementEnum AnnouncementType)
	{
		if(ShadowMutedPlayers[PlayerID] == false)
		{
			return true;
		}
		else
		{
			SCAnnouncement *Radio = Send_Client_Announcement(PlayerType,PlayerID,AnnouncementID,AnnouncementType,IconID,false,false);
			Radio->Set_Object_Dirty_Bits(PlayerID,NetworkObjectClass::BIT_CREATION);
			return false;
		}
	}

	virtual void OnPlayerLeave(int PlayerID)
	{
		ShadowMutedPlayers[PlayerID] = false;
	}
	
};

SHADOWMUTE shadowmute;


extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &shadowmute;
}
